package co.carmentang.bonvoyage;

import android.app.ActionBar;
import android.app.Activity;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageButton;
import android.widget.TextView;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.HashMap;

import android.os.Bundle;
import android.app.ListActivity;
import android.content.Intent;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;

import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ListAdapter;
import android.widget.SimpleAdapter;
import android.widget.TextView;
import android.widget.ListView;

    // GRIDVIEW: grid layout that is 1 column, displays images, extracts image(s) from journal entry
    // uses ADAPTER (extends base adapter??) to create some sort of image list view
    // each list should be clickable, as well as have an overlay of icons for adding a new journal entry
    // and also for viewing the gallery, a composite of all photos stored for that "album"
    // each album-image will be a clickable activity that goes to the respective entries_list

    // ALTERNATIVE: IS POSSIBLY A LISTVIEW with IMAGES ONLY (if possible?)

    //This is the string for the values from the intents from NewAlbumForm
    // Get optional values you have sent from MainActivity via intentExplicit.putExtra
    //String str1=getIntent().getStringExtra("First Value");
    //String str2 = getIntent().getStringExtra("Second Value");

//}


    public class AlbumActivity extends ListActivity {
        Intent intent;
        TextView albumId;
        DBController controller = new DBController(this);
        @Override
        protected void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            setContentView(R.layout.activity_album);
            ArrayList<HashMap<String, String>> animalList =  controller.getAllAnimals();
            if(animalList.size()!=0) {
                ListView lv = getListView();
                lv.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                    @Override
                    public void onItemClick(AdapterView<?> parent, View view,int position, long id) {
                        albumId = (TextView) view.findViewById(R.id.albumId);
                        String valAnimalId = albumId.getText().toString();
                        Intent  objIndent = new Intent(getApplicationContext(),EditAlbum.class);
                        objIndent.putExtra("albumId", valAnimalId);
                        startActivity(objIndent);
                    }
                });
                ListAdapter adapter = new SimpleAdapter( AlbumActivity.this,animalList, R.layout.view_album_entry, new String[] { "albumId","albumName"}, new int[] {R.id.albumId, R.id.albumName});
                setListAdapter(adapter);
            }
        }
        public void showAddForm(View view) {
            Intent objIntent = new Intent(getApplicationContext(), NewAlbumForm.class);
            startActivity(objIntent);
        }

        public void onClickExplicitIntent(View V)
        {
            // Create The Explicit Intent and Start The Activity
            // here you force explicitly to start SecondActivity.
            Intent intentExplicit =new Intent(this,Gallery.class);
            startActivity(intentExplicit);// Activity is started using explicit intent.
        }


    // this inflates the menu xml file
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.album, menu);
        return true;
    }



    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        if (id == R.id.action_settings) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
